
// modules

use super::{Key, Score};

// types

pub struct Eval_Cache {

   data: Vec<Entry>,

   bit:  u8,
   mask: u32,
}

#[derive(Clone)]
struct Entry {
   lock: u32,
   eval: Score,
}

// functions

impl Eval_Cache {

   pub fn new(bit: u8) -> Self {

      const { assert!(size_of::<Entry>() == 8) }

      assert!(bit >= 12);
      let size = 1 << bit;

      Self {

         data: vec![Entry::Def; size as usize],

         bit,
         mask: size - 1,
      }
   }

   pub fn probe(&self, key: Key) -> Option<Score> {

      let (index, lock) = key.split(self.bit);

      let entry = &self.data[(index & self.mask) as usize];
      (entry.lock == lock).then_some(entry.eval)
   }

   pub fn store(&mut self, key: Key, eval: Score) {

      let (index, lock) = key.split(self.bit);

      let entry = &mut self.data[(index & self.mask) as usize];
      *entry = Entry { lock, eval };
   }
}

impl Entry {

   const Def: Self = Self {
      lock: 0,
      eval: Score(0),
   };
}

