
// modules

use crate::prelude::*;

use super::{bb, square};

use bb::{Bits};
use square::{Inc};

// constants

pub const Inc_File: Inc = 8;
pub const Inc_Rank: Inc = 1;

// functions

pub const fn inc_move(sd: Side) -> Inc {

   match sd {
      Side::White =>  Inc_Rank,
      Side::Black => -Inc_Rank,
   }
}

pub const fn inc_cap_left(sd: Side) -> Inc {
   inc_move(sd) - Inc_File
}

pub const fn inc_cap_right(sd: Side) -> Inc {
   inc_move(sd) + Inc_File
}

pub const fn moves_from(sd: Side, from: Square) -> Bits {

   let mut res = BB::square(from).shift(inc_move(sd));

   if from.rank_side(sd) == 1 {
      res |= BB::square(from).shift(inc_move(sd) * 2);
   }

   res
}

pub const fn caps_from(sd: Side, from: Square) -> Bits {
   BB::square(from).shift(inc_cap_left (sd))
 | BB::square(from).shift(inc_cap_right(sd))
}

pub fn caps_froms(bd: &Board, sd: Side) -> Bits {
   attacks(bd.pawn(sd), sd)
}

pub fn moves(froms: BB, sd: Side) -> Bits {
   froms.shift(inc_move(sd))
}

pub fn attacks(froms: BB, sd: Side) -> Bits {
   froms.shift(inc_cap_left (sd))
 | froms.shift(inc_cap_right(sd))
}

pub fn moves_froms(froms: BB, tos: BB, inc: Inc) -> impl Iterator<Item = Move> {
   (froms & tos.shift(-inc)).iter().map(move |from| Move::new(from, from + inc))
}

