
// modules

use super::math::Int;

// constants

const Size: Bit = 64;

// types

type Bit  = u8;
type Bits = u64;

// functions

pub const fn bit(i: Bit) -> Bits {
   debug_assert!(i < Size);
   1 << i
}

pub const fn bits(i: Bit) -> Bits {
   bit(i) - 1
}

pub const fn is_single(n: Bits) -> bool {
   n != 0 && rest(n) == 0
}

pub const fn is_subset(l: Bits, r: Bits) -> bool {
   l & !r == 0
}

pub const fn is_disjoint(l: Bits, r: Bits) -> bool {
   l & r == 0
}

#[must_use]
pub const fn shift(n: Bits, i: i8) -> Bits {
   if i < 0 { n >> -i } else { n << i }
}

pub const fn first(n: Bits) -> Bit {
   debug_assert!(n != 0);
   n.trailing_zeros() as Bit
}

pub fn last(n: Bits) -> Bit {
   debug_assert!(n != 0);
   (n.leading_zeros() as Bit).rev(Size)
}

pub const fn rest(n: Bits) -> Bits {
   debug_assert!(n != 0);
   n & (n - 1)
}

pub const fn count(n: Bits) -> Bit {
   n.count_ones() as Bit
}

