
// modules

use std::fs;
use std::io::{self, prelude::*};

// functions

pub fn read_stdin_line() -> io::Result<Option<String>> {

   let line = &mut String::new();
   let bytes = io::stdin().read_line(line)?;
   if bytes == 0 { return Ok(None) } // EOF

   Ok(Some(line.trim().to_owned()))
}

// I/O for basic types

pub fn load_vector(file_name: &str) -> io::Result<Vec<f32>> {

   let file = fs::File::open(file_name)?;
   let size = file.metadata().unwrap().len() / size_of::<f32>() as u64;

   let mut v = vec![0_f32; size as usize];

   let reader = &mut io::BufReader::new(file);

   for x in &mut v {
      *x = read_f32_be(reader)?;
   }

   Ok(v)
}

pub fn read_f32_be<T: Read>(reader: &mut T) -> io::Result<f32> {

   let mut buffer = [0_u8; 4];
   reader.read_exact(&mut buffer)?;

   Ok(f32::from_be_bytes(buffer))
}

