
// modules

pub mod array;
pub mod bit;
pub mod data;
pub mod io;
pub mod math;
pub mod prelude;
pub mod random;
pub mod thread;
pub mod var;

use std::time;

// functions

pub fn char_add(l: char, r: i32) -> char {
   u8::try_from(l as i32 + r).unwrap() as char
}

pub fn char_sub(l: char, r: char) -> i32 {
   l as i32 - r as i32
}

pub fn append(l: &mut String, r: &str) {
   if !l.is_empty() { l.push(' ') }
   *l += r;
}

pub fn elapsed(start: &time::Instant) -> f32 {
   start.elapsed().as_micros() as f32 / 1E6 // seconds
}

